/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.DyeableComponent;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LampComponent
extends DigitalComponentBase<LampComponent>
implements DyeableComponent {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final Property<DyeColor> PROP_COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    private static final InterfaceLookup<LampComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSink.class, DigitalComponentBase.DEFAULT_INPUT_SIDES, RedstoneSink::instance).build();
    private boolean state = false;
    private DyeColor color = DyeColor.WHITE;

    public LampComponent(ComponentContext context) {
        super(SCMComponents.LAMP, context, INTERFACES);
    }

    private LampComponent(ComponentContext context, boolean state) {
        this(context);
        this.state = state;
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new LampComponent(context, this.state);
    }

    public ComponentState getState() {
        return (ComponentState)((ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.state))).m_61124_(PROP_COLOR, (Comparable)this.color);
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.LAMP.get());
    }

    public void setColor(DyeColor color) {
        this.updateExternalState(true, () -> {
            this.color = color;
        });
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        boolean newState;
        boolean bl = newState = newInputs != 0;
        if (this.state != newState) {
            this.updateExternalState(true, () -> {
                this.state = newState;
            });
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        DyeColor dyeColor;
        ItemStack stack = player.m_21120_(hand);
        DyeColor dyeColor2 = dyeColor = !stack.m_41619_() ? Utils.getDyeColor((ItemStack)stack) : null;
        if (dyeColor != null) {
            this.updateExternalState(true, () -> {
                this.color = dyeColor;
            });
            return InteractionResult.m_19078_((boolean)player.f_19853_.m_5776_());
        }
        return super.use(player, hand, sideHit, hit);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("state", this.state);
        tag.m_128405_("color", this.color.m_41060_());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.state = tag.m_128471_("state");
        this.color = DyeColor.m_41053_((int)tag.m_128451_("color"));
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON, PROP_COLOR});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.LAMP.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && Utils.getDyeColor((ItemStack)stack) != null) {
                return InteractionResult.m_19078_((boolean)true);
            }
            return super.use(state, player, hand, sideHit, hit);
        }

        public int getTint(ComponentState state, int tintIndex) {
            if (tintIndex == 0) {
                return ((DyeColor)state.m_61143_(PROP_COLOR)).m_41070_();
            }
            return super.getTint(state, tintIndex);
        }
    }
}

